package com.burhanstore.neonbubblequest.Utils.appuser

import android.content.Context
import android.content.SharedPreferences
import com.burhanstore.neonbubblequest.Utils.model.DB_Settings
import com.burhanstore.neonbubblequest.Utils.model.DB_User
import com.google.gson.Gson


class UserManager private constructor(context: Context) {

    companion object {
        private var instance: UserManager? = null

        fun getInstance(context: Context): UserManager {
            if (instance == null) {
                instance = UserManager(context.applicationContext)
            }
            return instance!!
        }
    }

    private val pref: SharedPreferences =
        context.getSharedPreferences(ConstApp.PREF_NAME, Context.MODE_PRIVATE)
    private val editor: SharedPreferences.Editor = pref.edit()

    fun saveBooleanValue(key: String, value: Boolean) {
        editor.putBoolean(key, value)
        editor.apply()
    }

    fun getBooleanValue(key: String): Boolean {
        return pref.getBoolean(key, false)
    }

    fun saveStringValue(key: String, value: String) {
        editor.putString(key, value)
        editor.apply()
    }

    fun getStringValue(key: String): String? {
        return pref.getString(key, "")
    }

    fun saveUser(user: DB_User) {
        editor.putString(ConstApp.USER, Gson().toJson(user))
        editor.apply()
    }

    fun getUser(): DB_User? {
        val json = pref.getString(ConstApp.USER, "")
        return if (!json.isNullOrEmpty()) Gson().fromJson(json, DB_User::class.java) else null
    }

    fun saveSetting(setting: DB_Settings?) {
        editor.putString(ConstApp.SETTING, Gson().toJson(setting))
        editor.apply()
    }

    fun getSetting(): DB_Settings? {
        val json = pref.getString(ConstApp.SETTING, "")
        return if (!json.isNullOrEmpty()) Gson().fromJson(json, DB_Settings::class.java) else null
    }

    fun clearUserData() {
        editor.clear()
        editor.apply()
    }
}
